#include "DM388_types.h"

#ifndef DM388_LED_H_
#define DM388_LED_H_

typedef enum
{
	GPIO_BANK_0= 0,
	GPIO_BANK_1,
	GPIO_BANK_2,
	GPIO_BANK_3
}GPIO_BANK_NUM;

#define WR_MEM_32(addr, data)    *(unsigned int*)(addr) =(unsigned int)(data)
#define RD_MEM_32(addr) 		 *(unsigned int*)(addr)

#define CTRL_MODULE_BASE_ADDR     0x48140000
#define    PINCNTL211    (    CTRL_MODULE_BASE_ADDR +    0x0B48    )
#define    PINCNTL16    (    CTRL_MODULE_BASE_ADDR +    0x083C    )
#define    PINCNTL123    (    CTRL_MODULE_BASE_ADDR +    0x09E8    )
#define    PINCNTL124    (    CTRL_MODULE_BASE_ADDR +    0x09EC    )
#define    PINCNTL132    (    CTRL_MODULE_BASE_ADDR +    0x0A0C    )

#define LED_NUM_GP3_3	3
#define LED_NUM_GP1_24  24
#define LED_NUM_GP1_25  25
#define LED_NUM_GP1_30  30
#define LED_NUM_GP0_9   9

#define LED_DELAY (0x3FFFF)

void LED_init(void);
void LED_on(UINT16 LED_num,UINT16 bank);
void LED_off(UINT16 LED_num,UINT16 bank);
INT32 led_test(void *testargs);

#endif /* DM388_LED_H_ */
